/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.diagram.VWGenericSubPropertyPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWActivitySubPropertyPanel
extends VWGenericSubPropertyPanel
implements DocumentListener {
    private JTextArea m_instructionsTextArea;

    public VWActivitySubPropertyPanel(VWAuthPropertyData authPropertyData, String stepType) {
        super(authPropertyData, stepType);
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedStep(VWMapNode vwMapNode) {
        if (vwMapNode == null || vwMapNode == this.m_selectedMapNode) {
            return;
        }
        this.m_selectedMapNode = vwMapNode;
        try {
            try {
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_instructionsTextArea.getDocument().removeDocumentListener(this);
                this.m_nameTextField.setText("");
                this.m_descriptionTextArea.setText("");
                this.m_instructionsTextArea.setText("");
                if (this.m_selectedMapNode != null) {
                    this.m_nameTextField.setText(this.getDisplayName());
                    this.m_descriptionTextArea.setText(this.m_selectedMapNode.getDescription());
                    this.m_instructionsTextArea.setText(this.m_selectedMapNode.getDescription());
                }
                this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_nameTextField.getDocument().addDocumentListener(this);
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                this.m_instructionsTextArea.getDocument().addDocumentListener(this);
            }
            Object var4_2 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_instructionsTextArea.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_instructionsTextArea.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    protected void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh138.htm");
    }

    protected void releaseReferences() {
        if (this.m_instructionsTextArea != null) {
            this.m_instructionsTextArea.getDocument().removeDocumentListener(this);
            this.m_instructionsTextArea.removeAll();
            this.m_instructionsTextArea = null;
        }
        super.releaseReferences();
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.getDescriptionPanel(), gbCons);
            ++gbCons.gridx;
            this.add((Component)this.getInstructionsPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void handleDocumentEvent(DocumentEvent event) {
        if (this.m_selectedMapNode == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            this.m_selectedMapNode.setDocumentation(this.m_descriptionTextArea.getText());
            this.m_authPropertyData.setDirty();
        } else if (event.getDocument() == this.m_instructionsTextArea.getDocument()) {
            this.m_selectedMapNode.setDescription(this.m_instructionsTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    private JPanel getInstructionsPanel() {
        try {
            VWToolbarBorder instructionsBorder = new VWToolbarBorder(VWResource.s_instructionsInUserInterface);
            JPanel childPanel = instructionsBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_instructionsTextArea = new JTextArea();
            this.m_instructionsTextArea.setName("m_instructionsTextArea_VWDiagramActivityPropertyPanel");
            this.m_instructionsTextArea.setLineWrap(true);
            this.m_instructionsTextArea.setWrapStyleWord(true);
            this.m_instructionsTextArea.setRows(3);
            this.m_instructionsTextArea.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_instructionsTextArea);
            childPanel.add((Component)new JScrollPane(this.m_instructionsTextArea), "Center");
            return instructionsBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

